// Copyright (C) 2022 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial

#ifndef QSQLITEZLIBSTORAGE_H
#define QSQLITEZLIBSTORAGE_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <QtInsightTracker/qtinsighttracker_global.h>
#include <QtInsightTracker/private/qsqlitestorage_p.h>

QT_BEGIN_NAMESPACE

class Q_INSIGHTTRACKER_EXPORT QSQLiteZlibStorage : public QSQLiteStorage
{
public:
    explicit QSQLiteZlibStorage(const QString &name = {}, int maxRecords = 0);

    bool open() override;
    bool add(const QByteArray &payload) override;
    QList<EventData> get(qsizetype n, qsizetype offset = 0) override;

private:
    QByteArray compress(const QByteArray &payload);
    QByteArray decompress(const QByteArray &payload);
    void trainDictionary();

    QByteArray m_dict;
    bool m_trainedDictionary = false;
};

QT_END_NAMESPACE

#endif // QSQLITEZLIBSTORAGE_H
